# AllHam - Comprehensive Radio Amateur Toolkit

![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)
![Open Source](https://badges.frapsoft.com/os/v1/open-source.svg?v=103)
![PHP](https://img.shields.io/badge/PHP-777BB4?style=flat&logo=php&logoColor=white)
![Bootstrap](https://img.shields.io/badge/Bootstrap-563D7C?style=flat&logo=bootstrap&logoColor=white)
![JavaScript](https://img.shields.io/badge/JavaScript-F7DF1E?style=flat&logo=javascript&logoColor=black)

AllHam is a comprehensive web application designed for radio amateurs, providing various calculations and information useful for amateur radio activities.

## 🚀 Features

- **Frequency Visualizer**: Visualize radio waves and calculate wavelength for a given frequency
- **Prefix Lookup**: Search for callsign prefixes and country information
- **Wavelength Calculator**: Calculate wavelength for a given frequency and vice versa
- **Callsign Phonetics**: Convert callsigns to phonetic alphabet for better communication
- **Antenna Calculator**: Calculate dimensions of various antenna types for a given frequency

## 📋 Requirements

- PHP 7.4 or higher
- Web server (Apache, Nginx, etc.)
- Modern web browser

## 🔧 Installation

1. Clone the repository:
   ```
   git clone https://github.com/OK2HSS/allham.git
   ```

2. Move the files to your web server directory:
   ```
   mv allham /path/to/your/webserver/
   ```

3. Access the application through your web browser:
   ```
   http://your-server/allham/
   ```

## 🖥️ Usage

### Frequency Visualizer
Enter a frequency, power, and terrain type to visualize radio waves and calculate the estimated range.

### Prefix Lookup
Enter a callsign prefix to find information about the country and region.

### Wavelength Calculator
Calculate wavelength from frequency or frequency from wavelength with various unit conversions.

### Callsign Phonetics
Convert a callsign to phonetic alphabet for clearer radio communication.

### Antenna Calculator
Calculate dimensions for different types of antennas based on the operating frequency.

## 📝 Project Structure

```
allham/
├── index.php           # Home page
├── frequency.php       # Frequency visualizer
├── prefix.php          # Prefix lookup
├── wavelength.php      # Wavelength calculator
├── callsign.php        # Callsign phonetics
├── antenna.php         # Antenna calculator
├── about.php           # About page
├── css/                # CSS files
│   ├── styles.css      # Main styles
│   ├── dark-mode.css   # Dark mode styles
│   └── form-styles.css # Form styles
└── js/                 # JavaScript files
    └── dark-mode.js    # Dark mode functionality
```

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## 📜 License

This project is licensed under the MIT License:

```
MIT License

Copyright (c) 2023 OK2HSS

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

## 📞 Contact

OK2HSS - [ok2hss@protonmail.com](mailto:ok2hss@protonmail.com)

Project Link: [https://github.com/OK2HSS/allham](https://github.com/OK2HSS/allham)

## 🙏 Acknowledgements

- [Bootstrap](https://getbootstrap.com/)
- [Font Awesome](https://fontawesome.com/)
- [jQuery](https://jquery.com/)
