<?php
// Funkce pro vyhledávání prefixů
function searchPrefix($prefix) {
    // Databáze prefixů (zjednodušená verze)
    $prefixDatabase = [
        'OK' => ['country' => 'Česká republika', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '15'],
        'OM' => ['country' => 'Slovensko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '15'],
        'DL' => ['country' => 'Německo', 'continent' => 'Evropa', 'itu' => '18', 'cq' => '14'],
        'SP' => ['country' => 'Polsko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '15'],
        'OE' => ['country' => 'Rakousko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '15'],
        'HA' => ['country' => 'Maďarsko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '15'],
        'S5' => ['country' => 'Slovinsko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '15'],
        'YU' => ['country' => 'Srbsko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '15'],
        'YO' => ['country' => 'Rumunsko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '20'],
        'LZ' => ['country' => 'Bulharsko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '20'],
        'UR' => ['country' => 'Ukrajina', 'continent' => 'Evropa', 'itu' => '29', 'cq' => '16'],
        'UA' => ['country' => 'Rusko', 'continent' => 'Evropa/Asie', 'itu' => '29', 'cq' => '16'],
        'ES' => ['country' => 'Estonsko', 'continent' => 'Evropa', 'itu' => '29', 'cq' => '15'],
        'YL' => ['country' => 'Lotyšsko', 'continent' => 'Evropa', 'itu' => '29', 'cq' => '15'],
        'LY' => ['country' => 'Litva', 'continent' => 'Evropa', 'itu' => '29', 'cq' => '15'],
        'OH' => ['country' => 'Finsko', 'continent' => 'Evropa', 'itu' => '18', 'cq' => '15'],
        'SM' => ['country' => 'Švédsko', 'continent' => 'Evropa', 'itu' => '18', 'cq' => '14'],
        'LA' => ['country' => 'Norsko', 'continent' => 'Evropa', 'itu' => '18', 'cq' => '14'],
        'OZ' => ['country' => 'Dánsko', 'continent' => 'Evropa', 'itu' => '18', 'cq' => '14'],
        'PA' => ['country' => 'Nizozemsko', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '14'],
        'ON' => ['country' => 'Belgie', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '14'],
        'F' => ['country' => 'Francie', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '14'],
        'EA' => ['country' => 'Španělsko', 'continent' => 'Evropa', 'itu' => '37', 'cq' => '14'],
        'CT' => ['country' => 'Portugalsko', 'continent' => 'Evropa', 'itu' => '37', 'cq' => '14'],
        'I' => ['country' => 'Itálie', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '15'],
        'SV' => ['country' => 'Řecko', 'continent' => 'Evropa', 'itu' => '28', 'cq' => '20'],
        'G' => ['country' => 'Anglie', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '14'],
        'GM' => ['country' => 'Skotsko', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '14'],
        'GW' => ['country' => 'Wales', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '14'],
        'EI' => ['country' => 'Irsko', 'continent' => 'Evropa', 'itu' => '27', 'cq' => '14'],
        'W' => ['country' => 'USA', 'continent' => 'Severní Amerika', 'itu' => '8', 'cq' => '5'],
        'VE' => ['country' => 'Kanada', 'continent' => 'Severní Amerika', 'itu' => '9', 'cq' => '5'],
        'XE' => ['country' => 'Mexiko', 'continent' => 'Severní Amerika', 'itu' => '10', 'cq' => '6'],
        'PY' => ['country' => 'Brazílie', 'continent' => 'Jižní Amerika', 'itu' => '12', 'cq' => '11'],
        'LU' => ['country' => 'Argentina', 'continent' => 'Jižní Amerika', 'itu' => '14', 'cq' => '13'],
        'CE' => ['country' => 'Chile', 'continent' => 'Jižní Amerika', 'itu' => '14', 'cq' => '12'],
        'JA' => ['country' => 'Japonsko', 'continent' => 'Asie', 'itu' => '45', 'cq' => '25'],
        'BY' => ['country' => 'Čína', 'continent' => 'Asie', 'itu' => '44', 'cq' => '24'],
        'VU' => ['country' => 'Indie', 'continent' => 'Asie', 'itu' => '41', 'cq' => '22'],
        'HS' => ['country' => 'Thajsko', 'continent' => 'Asie', 'itu' => '49', 'cq' => '26'],
        'VK' => ['country' => 'Austrálie', 'continent' => 'Oceánie', 'itu' => '55', 'cq' => '30'],
        'ZL' => ['country' => 'Nový Zéland', 'continent' => 'Oceánie', 'itu' => '60', 'cq' => '32'],
        'ZS' => ['country' => 'Jižní Afrika', 'continent' => 'Afrika', 'itu' => '57', 'cq' => '38'],
        '5N' => ['country' => 'Nigérie', 'continent' => 'Afrika', 'itu' => '46', 'cq' => '35'],
        'SU' => ['country' => 'Egypt', 'continent' => 'Afrika', 'itu' => '38', 'cq' => '34'],
    ];

    // Vyhledání prefixu
    $prefix = strtoupper($prefix);
    $results = [];

    foreach ($prefixDatabase as $key => $value) {
        if (strpos($key, $prefix) === 0 || strpos($prefix, $key) === 0) {
            $results[$key] = $value;
        }
    }

    return $results;
}

// Zpracování formuláře
$searchResults = [];
$searchTerm = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["prefix"])) {
    $searchTerm = trim($_POST["prefix"]);
    if (!empty($searchTerm)) {
        $searchResults = searchPrefix($searchTerm);
    }
}

// Nastavení tmavého režimu jako výchozího
$darkMode = true;
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vyhledávání prefixů - AllHam</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
    <!-- Dark Mode CSS -->
    <link rel="stylesheet" href="css/dark-mode.css">
    <!-- Form Styles CSS -->
    <link rel="stylesheet" href="css/form-styles.css">
    <style>
        /* Tmavý režim jako výchozí */
        body {
            background-color: #121212;
            color: #e0e0e0;
        }

        .card {
            background-color: #1e1e1e;
            border-color: #333;
        }

        .card-body {
            color: #e0e0e0;
        }

        .form-control, .form-select {
            background-color: #2a2a2a;
            border-color: #444;
            color: #e0e0e0;
        }

        .form-control:focus, .form-select:focus {
            background-color: #333;
            color: #fff;
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }

        /* Tabulka */
        .table-dark {
            background-color: #2a2a2a;
            color: #e0e0e0;
        }

        .table-dark th {
            background-color: #0277bd;
            color: white;
            border-color: #0288d1;
        }

        .table-dark td {
            border-color: #444;
        }

        /* Výsledky vyhledávání */
        .search-result {
            background-color: #2a2a2a;
            border-radius: 0.5rem;
            padding: 1rem;
            margin-bottom: 1rem;
            border-left: 4px solid #0d6efd;
        }

        .search-result h4 {
            color: #0d6efd;
            margin-bottom: 0.5rem;
        }

        .search-result p {
            margin-bottom: 0.25rem;
        }

        .no-results {
            background-color: #2a2a2a;
            border-radius: 0.5rem;
            padding: 1rem;
            margin-bottom: 1rem;
            border-left: 4px solid #dc3545;
            color: #e0e0e0;
        }
    </style>
</head>
<body class="dark-mode">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">AllHam</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home"></i> Domů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="frequency.php"><i class="fas fa-broadcast-tower"></i> Frekvenční vizualizér</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="prefix.php"><i class="fas fa-globe"></i> Vyhledávání prefixů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="wavelength.php"><i class="fas fa-wave-square"></i> Délka vlny</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="callsign.php"><i class="fas fa-microphone"></i> Hláskovač</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="antenna.php"><i class="fas fa-satellite-dish"></i> Výpočet antény</a>
                    </li>
                </ul>

            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1 class="text-center mb-4 text-light">Vyhledávání prefixů</h1>

        <div class="row">
            <div class="col-md-6 mx-auto">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title">Zadejte prefix</h3>
                    </div>
                    <div class="card-body">
                        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                            <div class="mb-3">
                                <label for="prefix" class="form-label">Prefix volací značky</label>
                                <input type="text" class="form-control" id="prefix" name="prefix" placeholder="Např. OK, DL, W..." value="<?php echo htmlspecialchars($searchTerm); ?>" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Vyhledat</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <?php if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["prefix"])): ?>
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h3 class="card-title">Výsledky vyhledávání pro "<?php echo htmlspecialchars($searchTerm); ?>"</h3>
                        </div>
                        <div class="card-body">
                            <?php if (empty($searchResults)): ?>
                                <div class="no-results">
                                    <h4>Žádné výsledky</h4>
                                    <p>Pro zadaný prefix nebyly nalezeny žádné výsledky. Zkuste jiný prefix.</p>
                                </div>
                            <?php else: ?>
                                <?php foreach ($searchResults as $prefix => $data): ?>
                                    <div class="search-result">
                                        <h4><?php echo htmlspecialchars($prefix); ?></h4>
                                        <p><strong>Země:</strong> <?php echo htmlspecialchars($data['country']); ?></p>
                                        <p><strong>Kontinent:</strong> <?php echo htmlspecialchars($data['continent']); ?></p>
                                        <p><strong>ITU zóna:</strong> <?php echo htmlspecialchars($data['itu']); ?></p>
                                        <p><strong>CQ zóna:</strong> <?php echo htmlspecialchars($data['cq']); ?></p>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h3 class="card-title">Informace o prefixech</h3>
                    </div>
                    <div class="card-body">
                        <p>Prefixy volacích značek jsou přidělovány podle mezinárodních dohod a označují zemi nebo region, ze kterého stanice vysílá. Každá země má přidělený jeden nebo více prefixů.</p>
                        <p>Například:</p>
                        <ul>
                            <li><strong>OK</strong> - Česká republika</li>
                            <li><strong>OM</strong> - Slovensko</li>
                            <li><strong>DL</strong> - Německo</li>
                            <li><strong>SP</strong> - Polsko</li>
                            <li><strong>W, K, N, AA-AK</strong> - USA</li>
                        </ul>
                        <p>Kompletní seznam prefixů najdete v oficiálních dokumentech ITU (International Telecommunication Union) nebo na stránkách radioamatérských organizací.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-white text-center text-lg-start mt-4">
        <div class="container p-4">
            <div class="row">
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>O projektu AllHam</h5>
                    <p>
                        AllHam je komplexní nástroj pro radioamatéry, který poskytuje různé výpočty a informace užitečné pro radioamatérskou činnost.
                    </p>
                </div>
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>Kontakt</h5>
                    <p>
                        <a href="https://www.OK2HSS.cz" class="text-info">www.ok2hss.cz</a>
                    </p>
                </div>
            </div>
        </div>
        <div class="text-center p-3" style="background-color: rgba(0, 0, 0, 0.2);">
            © 2023 AllHam
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Dark Mode JS -->
    <script src="js/dark-mode.js"></script>
</body>
</html>
