<?php
// Konstanty
define('SPEED_OF_LIGHT', 299792458); // Rychlost světla v m/s

// Funkce pro výpočet vlnové délky z frekvence
function calculateWavelength($frequency, $unit) {
    // Převod frekvence na Hz podle jednotky
    $frequencyHz = $frequency;

    switch ($unit) {
        case 'kHz':
            $frequencyHz = $frequency * 1000;
            break;
        case 'MHz':
            $frequencyHz = $frequency * 1000000;
            break;
        case 'GHz':
            $frequencyHz = $frequency * 1000000000;
            break;
    }

    // Výpočet vlnové délky v metrech
    $wavelengthMeters = SPEED_OF_LIGHT / $frequencyHz;

    return $wavelengthMeters;
}

// Funkce pro výpočet frekvence z vlnové délky
function calculateFrequency($wavelength, $unit) {
    // Převod vlnové délky na metry podle jednotky
    $wavelengthMeters = $wavelength;

    switch ($unit) {
        case 'mm':
            $wavelengthMeters = $wavelength / 1000;
            break;
        case 'cm':
            $wavelengthMeters = $wavelength / 100;
            break;
        case 'm':
            // Již v metrech, není potřeba převod
            break;
        case 'km':
            $wavelengthMeters = $wavelength * 1000;
            break;
    }

    // Výpočet frekvence v Hz
    $frequencyHz = SPEED_OF_LIGHT / $wavelengthMeters;

    return $frequencyHz;
}

// Zpracování formuláře
$calculationType = 'frequency'; // Výchozí typ výpočtu
$frequency = 145; // Výchozí hodnota
$frequencyUnit = 'MHz'; // Výchozí jednotka
$wavelength = 2.07; // Výchozí hodnota
$wavelengthUnit = 'm'; // Výchozí jednotka

$result = null;
$resultText = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["calculation_type"])) {
        $calculationType = $_POST["calculation_type"];

        if ($calculationType == 'frequency') {
            // Výpočet vlnové délky z frekvence
            if (isset($_POST["frequency"]) && isset($_POST["frequency_unit"])) {
                $frequency = floatval($_POST["frequency"]);
                $frequencyUnit = $_POST["frequency_unit"];

                if ($frequency > 0) {
                    $wavelengthMeters = calculateWavelength($frequency, $frequencyUnit);

                    // Formátování výsledku
                    $result = [
                        'meters' => $wavelengthMeters,
                        'centimeters' => $wavelengthMeters * 100,
                        'millimeters' => $wavelengthMeters * 1000,
                        'kilometers' => $wavelengthMeters / 1000
                    ];

                    $resultText = "Pro frekvenci $frequency $frequencyUnit je vlnová délka:";
                }
            }
        } else {
            // Výpočet frekvence z vlnové délky
            if (isset($_POST["wavelength"]) && isset($_POST["wavelength_unit"])) {
                $wavelength = floatval($_POST["wavelength"]);
                $wavelengthUnit = $_POST["wavelength_unit"];

                if ($wavelength > 0) {
                    $frequencyHz = calculateFrequency($wavelength, $wavelengthUnit);

                    // Formátování výsledku
                    $result = [
                        'Hz' => $frequencyHz,
                        'kHz' => $frequencyHz / 1000,
                        'MHz' => $frequencyHz / 1000000,
                        'GHz' => $frequencyHz / 1000000000
                    ];

                    $resultText = "Pro vlnovou délku $wavelength $wavelengthUnit je frekvence:";
                }
            }
        }
    }
}

// Nastavení tmavého režimu jako výchozího
$darkMode = true;
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Délka vlny - AllHam</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
    <!-- Dark Mode CSS -->
    <link rel="stylesheet" href="css/dark-mode.css">
    <!-- Form Styles CSS -->
    <link rel="stylesheet" href="css/form-styles.css">
    <style>
        /* Tmavý režim jako výchozí */
        body {
            background-color: #121212;
            color: #e0e0e0;
        }

        .card {
            background-color: #1e1e1e;
            border-color: #333;
        }

        .card-body {
            color: #e0e0e0;
        }

        .form-control, .form-select {
            background-color: #2a2a2a;
            border-color: #444;
            color: #e0e0e0;
        }

        .form-control:focus, .form-select:focus {
            background-color: #333;
            color: #fff;
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }

        /* Výsledky */
        .result-item {
            margin-bottom: 1.5rem;
            padding: 1rem;
            background-color: #2a2a2a;
            border-radius: 0.5rem;
            border-left: 4px solid #0d6efd;
        }

        .result-item h4 {
            color: #0d6efd;
            margin-bottom: 0.5rem;
        }

        .result-item p {
            font-size: 1.2rem;
            margin-bottom: 0.25rem;
        }

        /* Přepínač formuláře */
        .form-check-input {
            background-color: #2a2a2a;
            border-color: #444;
        }

        .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }
    </style>
</head>
<body class="dark-mode">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">AllHam</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home"></i> Domů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="frequency.php"><i class="fas fa-broadcast-tower"></i> Frekvenční vizualizér</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="prefix.php"><i class="fas fa-globe"></i> Vyhledávání prefixů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="wavelength.php"><i class="fas fa-wave-square"></i> Délka vlny</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="callsign.php"><i class="fas fa-microphone"></i> Hláskovač</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="antenna.php"><i class="fas fa-satellite-dish"></i> Výpočet antény</a>
                    </li>

                </ul>

            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1 class="text-center mb-4 text-light">Výpočet délky vlny a frekvence</h1>

        <div class="row">
            <div class="col-md-6 mx-auto">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title">Parametry výpočtu</h3>
                    </div>
                    <div class="card-body">
                        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                            <div class="mb-3">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="calculation_type" id="frequency_to_wavelength" value="frequency" <?php echo $calculationType == 'frequency' ? 'checked' : ''; ?> onchange="toggleCalculationType()">
                                    <label class="form-check-label" for="frequency_to_wavelength">Frekvence → Vlnová délka</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="calculation_type" id="wavelength_to_frequency" value="wavelength" <?php echo $calculationType == 'wavelength' ? 'checked' : ''; ?> onchange="toggleCalculationType()">
                                    <label class="form-check-label" for="wavelength_to_frequency">Vlnová délka → Frekvence</label>
                                </div>
                            </div>

                            <div id="frequency_input" class="mb-3" <?php echo $calculationType == 'wavelength' ? 'style="display: none;"' : ''; ?>>
                                <label for="frequency" class="form-label">Frekvence</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="frequency" name="frequency" placeholder="Např. 145" value="<?php echo $frequency; ?>" step="any" required>
                                    <select class="form-select" id="frequency_unit" name="frequency_unit">
                                        <option value="Hz" <?php echo $frequencyUnit == 'Hz' ? 'selected' : ''; ?>>Hz</option>
                                        <option value="kHz" <?php echo $frequencyUnit == 'kHz' ? 'selected' : ''; ?>>kHz</option>
                                        <option value="MHz" <?php echo $frequencyUnit == 'MHz' ? 'selected' : ''; ?>>MHz</option>
                                        <option value="GHz" <?php echo $frequencyUnit == 'GHz' ? 'selected' : ''; ?>>GHz</option>
                                    </select>
                                </div>
                            </div>

                            <div id="wavelength_input" class="mb-3" <?php echo $calculationType == 'frequency' ? 'style="display: none;"' : ''; ?>>
                                <label for="wavelength" class="form-label">Vlnová délka</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="wavelength" name="wavelength" placeholder="Např. 2.07" value="<?php echo $wavelength; ?>" step="any" required>
                                    <select class="form-select" id="wavelength_unit" name="wavelength_unit">
                                        <option value="mm" <?php echo $wavelengthUnit == 'mm' ? 'selected' : ''; ?>>mm</option>
                                        <option value="cm" <?php echo $wavelengthUnit == 'cm' ? 'selected' : ''; ?>>cm</option>
                                        <option value="m" <?php echo $wavelengthUnit == 'm' ? 'selected' : ''; ?>>m</option>
                                        <option value="km" <?php echo $wavelengthUnit == 'km' ? 'selected' : ''; ?>>km</option>
                                    </select>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Vypočítat</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <?php if ($result !== null): ?>
            <div class="row mt-4">
                <div class="col-md-6 mx-auto">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h3 class="card-title">Výsledky výpočtu</h3>
                        </div>
                        <div class="card-body">
                            <p><?php echo $resultText; ?></p>

                            <?php if ($calculationType == 'frequency'): ?>
                                <div class="result-item">
                                    <h4>Vlnová délka</h4>
                                    <p><?php echo number_format($result['meters'], 6); ?> m</p>
                                    <p><?php echo number_format($result['centimeters'], 4); ?> cm</p>
                                    <p><?php echo number_format($result['millimeters'], 2); ?> mm</p>
                                    <p><?php echo number_format($result['kilometers'], 9); ?> km</p>
                                </div>
                            <?php else: ?>
                                <div class="result-item">
                                    <h4>Frekvence</h4>
                                    <p><?php echo number_format($result['Hz'], 2); ?> Hz</p>
                                    <p><?php echo number_format($result['kHz'], 4); ?> kHz</p>
                                    <p><?php echo number_format($result['MHz'], 6); ?> MHz</p>
                                    <p><?php echo number_format($result['GHz'], 9); ?> GHz</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h3 class="card-title">Informace o vlnové délce a frekvenci</h3>
                    </div>
                    <div class="card-body">
                        <p>Vlnová délka a frekvence jsou vzájemně propojené veličiny, které popisují elektromagnetické vlny. Jejich vztah je dán vzorcem:</p>
                        <div class="text-center mb-3">
                            <h4>λ = c / f</h4>
                            <p>kde λ je vlnová délka v metrech, c je rychlost světla (299 792 458 m/s) a f je frekvence v Hz.</p>
                        </div>
                        <p>Tento vztah znamená, že čím vyšší je frekvence, tím kratší je vlnová délka a naopak. Například:</p>
                        <ul>
                            <li>Frekvence 145 MHz odpovídá vlnové délce přibližně 2,07 metru</li>
                            <li>Frekvence 435 MHz odpovídá vlnové délce přibližně 0,69 metru (69 cm)</li>
                            <li>Frekvence 2,4 GHz odpovídá vlnové délce přibližně 12,5 cm</li>
                        </ul>
                        <p>Znalost vlnové délky je důležitá zejména při návrhu antén, kde délka prvků antény často přímo souvisí s vlnovou délkou signálu.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-white text-center text-lg-start mt-4">
        <div class="container p-4">
            <div class="row">
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>O projektu AllHam</h5>
                    <p>
                        AllHam je komplexní nástroj pro radioamatéry, který poskytuje různé výpočty a informace užitečné pro radioamatérskou činnost.
                    </p>
                </div>
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>Kontakt</h5>
                    <p>
                        <a href="https://www.OK2HSS.cz" class="text-info">www.ok2hss.cz</a>
                    </p>
                </div>
            </div>
        </div>
        <div class="text-center p-3" style="background-color: rgba(0, 0, 0, 0.2);">
            © 2023 AllHam
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Dark Mode JS -->
    <script src="js/dark-mode.js"></script>

    <script>
        // Funkce pro přepínání typu výpočtu
        function toggleCalculationType() {
            const frequencyToWavelength = document.getElementById('frequency_to_wavelength').checked;
            const frequencyInput = document.getElementById('frequency_input');
            const wavelengthInput = document.getElementById('wavelength_input');

            if (frequencyToWavelength) {
                frequencyInput.style.display = 'block';
                wavelengthInput.style.display = 'none';
                document.getElementById('frequency').required = true;
                document.getElementById('wavelength').required = false;
            } else {
                frequencyInput.style.display = 'none';
                wavelengthInput.style.display = 'block';
                document.getElementById('frequency').required = false;
                document.getElementById('wavelength').required = true;
            }
        }
    </script>
</body>
</html>
