// Dark mode functionality for AllHam application - always dark mode

document.addEventListener('DOMContentLoaded', function() {
    // Always use dark mode
    document.body.classList.add('dark-mode');

    // Set dark mode in localStorage
    localStorage.setItem('darkMode', 'dark');

    // Update form elements for dark mode
    updateFormElements();

    // Function to update form elements for dark mode
    function updateFormElements() {
        // Update placeholder colors for better visibility
        const inputs = document.querySelectorAll('input, textarea, select');

        inputs.forEach(input => {
            // Ensure background and text colors are set for dark mode
            if (input.classList.contains('form-control') || input.classList.contains('form-select')) {
                input.style.transition = 'background-color 0.3s, color 0.3s, border-color 0.3s';
            }
        });
    }
});
