<?php
// Nastavení tmavého režimu jako výchozího
$darkMode = true;
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>O projektu - AllHam</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
    <!-- Dark Mode CSS -->
    <link rel="stylesheet" href="css/dark-mode.css">
    <!-- Form Styles CSS -->
    <link rel="stylesheet" href="css/form-styles.css">
    <style>
        /* Tmavý režim jako výchozí */
        body {
            background-color: #121212;
            color: #e0e0e0;
        }

        .card {
            background-color: #1e1e1e;
            border-color: #333;
        }

        .card-body {
            color: #e0e0e0;
        }

        /* Styly pro sekci O projektu */
        .about-section {
            padding: 2rem;
            margin-bottom: 2rem;
            background-color: #1e1e1e;
            border-radius: 0.5rem;
            border-left: 4px solid #0d6efd;
        }

        .about-section h2 {
            color: #0d6efd;
            margin-bottom: 1rem;
        }

        .about-section p {
            margin-bottom: 1rem;
            line-height: 1.6;
        }

        .feature-list {
            list-style-type: none;
            padding-left: 0;
        }

        .feature-list li {
            margin-bottom: 0.5rem;
            padding-left: 1.5rem;
            position: relative;
        }

        .feature-list li:before {
            content: "\f00c";
            font-family: "Font Awesome 5 Free";
            font-weight: 900;
            position: absolute;
            left: 0;
            color: #0d6efd;
        }

        .team-member {
            text-align: center;
            margin-bottom: 2rem;
        }

        .team-member img {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 1rem;
            border: 3px solid #0d6efd;
        }

        .team-member h4 {
            color: #0d6efd;
            margin-bottom: 0.5rem;
        }

        .team-member p {
            margin-bottom: 0.5rem;
        }

        .social-links {
            margin-top: 1rem;
        }

        .social-links a {
            display: inline-block;
            margin: 0 0.5rem;
            color: #e0e0e0;
            font-size: 1.2rem;
            transition: color 0.3s;
        }

        .social-links a:hover {
            color: #0d6efd;
        }

        .timeline {
            position: relative;
            padding: 1rem 0;
        }

        .timeline:before {
            content: '';
            position: absolute;
            height: 100%;
            width: 2px;
            background-color: #0d6efd;
            left: 50%;
            transform: translateX(-50%);
        }

        .timeline-item {
            margin-bottom: 2rem;
            position: relative;
        }

        .timeline-content {
            background-color: #2a2a2a;
            border-radius: 0.5rem;
            padding: 1.5rem;
            position: relative;
            width: 45%;
            margin-left: auto;
        }

        .timeline-item:nth-child(even) .timeline-content {
            margin-left: 0;
            margin-right: auto;
        }

        .timeline-content:before {
            content: '';
            position: absolute;
            top: 20px;
            width: 20px;
            height: 20px;
            background-color: #0d6efd;
            border-radius: 50%;
        }

        .timeline-item:nth-child(odd) .timeline-content:before {
            left: -30px;
        }

        .timeline-item:nth-child(even) .timeline-content:before {
            right: -30px;
        }

        .timeline-date {
            color: #0d6efd;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }

        @media (max-width: 768px) {
            .timeline:before {
                left: 30px;
            }

            .timeline-content {
                width: calc(100% - 60px);
                margin-left: 60px;
            }

            .timeline-item:nth-child(even) .timeline-content {
                margin-left: 60px;
                margin-right: 0;
            }

            .timeline-content:before {
                left: -30px;
            }

            .timeline-item:nth-child(even) .timeline-content:before {
                right: auto;
                left: -30px;
            }
        }
    </style>
</head>
<body class="dark-mode">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">AllHam</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home"></i> Domů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="frequency.php"><i class="fas fa-broadcast-tower"></i> Frekvenční vizualizér</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="prefix.php"><i class="fas fa-globe"></i> Vyhledávání prefixů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="wavelength.php"><i class="fas fa-wave-square"></i> Délka vlny</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="callsign.php"><i class="fas fa-microphone"></i> Hláskovač</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="antenna.php"><i class="fas fa-satellite-dish"></i> Výpočet antény</a>
                    </li>
                </ul>

            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1 class="text-center mb-4 text-light">O projektu AllHam</h1>

        <div class="about-section">
            <h2>Co je AllHam?</h2>
            <p>
                AllHam je komplexní webová aplikace určená pro radioamatéry, která poskytuje různé výpočty a informace užitečné pro radioamatérskou činnost. Projekt vznikl s cílem vytvořit jednoduché a intuitivní nástroje, které pomohou radioamatérům při jejich každodenní práci.
            </p>
            <p>
                Aplikace je navržena tak, aby byla snadno použitelná a přístupná na různých zařízeních. Díky responzivnímu designu ji můžete používat na počítači, tabletu i mobilním telefonu.
            </p>
        </div>

        <div class="about-section">
            <h2>Funkce a nástroje</h2>
            <p>
                AllHam nabízí několik užitečných nástrojů, které vám pomohou při radioamatérské činnosti:
            </p>
            <ul class="feature-list">
                <li><strong>Frekvenční vizualizér</strong> - Vizualizace rádiových vln a výpočet délky vlny pro zadanou frekvenci.</li>
                <li><strong>Vyhledávání prefixů</strong> - Vyhledávání prefixů volacích značek a informací o zemích.</li>
                <li><strong>Délka vlny</strong> - Výpočet délky vlny pro zadanou frekvenci a naopak. Převod mezi jednotkami frekvence a vlnové délky.</li>
                <li><strong>Hláskovač</strong> - Převod volací značky na fonetickou abecedu pro lepší komunikaci.</li>
                <li><strong>Výpočet antény</strong> - Výpočet rozměrů různých typů antén pro zadanou frekvenci.</li>
            </ul>
        </div>

        <div class="about-section">
            <h2>Technologie</h2>
            <p>
                AllHam je vytvořen pomocí moderních webových technologií:
            </p>
            <ul class="feature-list">
                <li><strong>PHP</strong> - Serverový skriptovací jazyk pro zpracování formulářů a výpočtů.</li>
                <li><strong>HTML5 & CSS3</strong> - Pro strukturu a vzhled aplikace.</li>
                <li><strong>Bootstrap 5</strong> - Framework pro responzivní design.</li>
                <li><strong>JavaScript</strong> - Pro interaktivní prvky a přepínání tmavého/světlého režimu.</li>
                <li><strong>Font Awesome</strong> - Pro ikony a vizuální prvky.</li>
            </ul>
        </div>

        <div class="about-section">
            <h2>Historie projektu</h2>
            <div class="timeline">
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Leden 2023</div>
                        <h4>Počátek projektu</h4>
                        <p>Zahájení vývoje projektu AllHam s cílem vytvořit užitečné nástroje pro radioamatéry.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Březen 2023</div>
                        <h4>První verze</h4>
                        <p>Vydání první verze aplikace s základními nástroji pro výpočet délky vlny a vyhledávání prefixů.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Květen 2023</div>
                        <h4>Rozšíření funkcí</h4>
                        <p>Přidání nových nástrojů jako hláskovač a výpočet antény.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Červenec 2023</div>
                        <h4>Redesign</h4>
                        <p>Kompletní přepracování designu aplikace s důrazem na uživatelskou přívětivost a tmavý režim.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Září 2023</div>
                        <h4>Přechod na PHP</h4>
                        <p>Přepracování aplikace z HTML na PHP pro lepší funkcionalitu a zpracování dat na serveru.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Listopad 2023</div>
                        <h4>Optimalizace výkonu</h4>
                        <p>Optimalizace kódu a databáze pro rychlejší načítání a zpracování dat.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Leden 2024</div>
                        <h4>Vylepšení uživatelského rozhraní</h4>
                        <p>Aktualizace uživatelského rozhraní s důrazem na přístupnost a použitelnost na všech zařízeních.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Březen 2024</div>
                        <h4>Rozšíření databáze prefixů</h4>
                        <p>Aktualizace a rozšíření databáze prefixů volacích značek s podrobnějšími informacemi o regionech.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Květen 2024</div>
                        <h4>Vylepšení výpočtů antén</h4>
                        <p>Implementace přesnějších algoritmů pro výpočty antén s vylepšenou přesností.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Červenec 2024</div>
                        <h4>Vylepšení vizualizací</h4>
                        <p>Přidání detailnějších grafických vizualizací pro frekvenční analýzu.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Září 2024</div>
                        <h4>Optimalizace pro mobilní zařízení</h4>
                        <p>Vylepšení responzivního designu pro lepší použitelnost na mobilních zařízeních.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Listopad 2024</div>
                        <h4>Příprava na AllHam 2.0</h4>
                        <p>Zahájení prací na nové verzi aplikace s vylepšenou architekturou a novými funkcemi.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Leden 2025</div>
                        <h4>Testování AllHam 2.0</h4>
                        <p>Zahájení testování nové verze aplikace a oprava nalezených chyb.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Březen 2025</div>
                        <h4>Finální úpravy</h4>
                        <p>Dokončení finálních úprav a optimalizací před vydáním nové verze.</p>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-content">
                        <div class="timeline-date">Duben 2025</div>
                        <h4>AllHam 2.0</h4>
                        <p>Vydání kompletně přepracované verze AllHam 2.0 s vylepšenou architekturou, optimalizovaným kódem a novými funkcemi.</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="about-section">
            <h2>Autor projektu</h2>
            <div class="row">
                <div class="col-md-4 mx-auto">
                    <div class="team-member">
                        <img src="https://via.placeholder.com/150" alt="OK2HSS">
                        <h4>OK2HSS</h4>
                        <p>Radioamatér a vývojář</p>
                        <div class="social-links">
                            <a href="https://www.OK2HSS.cz" target="_blank"><i class="fas fa-globe"></i></a>
                            <a href="#" target="_blank"><i class="fab fa-twitter"></i></a>
                            <a href="#" target="_blank"><i class="fab fa-github"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="about-section">
            <h2>Kontakt</h2>
            <p>
                Máte-li jakékoliv dotazy, návrhy na zlepšení nebo jste našli chybu, neváhejte nás kontaktovat:
            </p>
            <ul class="feature-list">
                <li><strong>Web:</strong> <a href="https://www.OK2HSS.cz" class="text-info">www.ok2hss.cz</a></li>
                <li><strong>Email:</strong> <a href="mailto:ok2hss@protonmail.com" class="text-info">ok2hss@protonmail.com</a></li>
            </ul>
        </div>
    </div>

    <footer class="bg-dark text-white text-center text-lg-start mt-4">
        <div class="container p-4">
            <div class="row">
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>O projektu AllHam</h5>
                    <p>
                        AllHam je komplexní nástroj pro radioamatéry, který poskytuje různé výpočty a informace užitečné pro radioamatérskou činnost.
                    </p>
                </div>
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>Kontakt</h5>
                    <p>
                        <a href="https://www.OK2HSS.cz" class="text-info">www.ok2hss.cz</a>
                    </p>
                </div>
            </div>
        </div>
        <div class="text-center p-3" style="background-color: rgba(0, 0, 0, 0.2);">
            © 2023 AllHam
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Dark Mode JS -->
    <script src="js/dark-mode.js"></script>
</body>
</html>
