<?php
// Konstanty
define('SPEED_OF_LIGHT', 299792458); // Rychlost světla v m/s

// Funkce pro výpočet délky antény
function calculateAntennaLength($frequency, $frequencyUnit, $antennaType, $resultUnit) {
    // Převod frekvence na Hz podle jednotky
    $frequencyHz = $frequency;

    switch ($frequencyUnit) {
        case 'Hz':
            // Již v Hz, není potřeba převod
            break;
        case 'kHz':
            $frequencyHz = $frequency * 1000;
            break;
        case 'MHz':
            $frequencyHz = $frequency * 1000000;
            break;
        case 'GHz':
            $frequencyHz = $frequency * 1000000000;
            break;
    }

    // Výpočet vlnové délky v metrech
    $wavelengthMeters = SPEED_OF_LIGHT / $frequencyHz;

    // Výpočet délky antény podle typu
    $antennaLengthMeters = 0;
    $groundLengthMeters = 0;

    switch ($antennaType) {
        case 'fullWave':
            $antennaLengthMeters = $wavelengthMeters;
            $groundLengthMeters = $wavelengthMeters * 0.28;
            break;
        case 'halfWave':
            $antennaLengthMeters = $wavelengthMeters / 2;
            $groundLengthMeters = $wavelengthMeters * 0.28 / 2;
            break;
        case 'quarterWave':
            $antennaLengthMeters = $wavelengthMeters / 4;
            $groundLengthMeters = $wavelengthMeters * 0.28 / 4;
            break;
    }

    // Převod na požadované jednotky
    $antennaLength = $antennaLengthMeters;
    $groundLength = $groundLengthMeters;

    switch ($resultUnit) {
        case 'm':
            // Již v metrech, není potřeba převod
            break;
        case 'cm':
            $antennaLength = $antennaLengthMeters * 100;
            $groundLength = $groundLengthMeters * 100;
            break;
        case 'mm':
            $antennaLength = $antennaLengthMeters * 1000;
            $groundLength = $groundLengthMeters * 1000;
            break;
    }

    return [
        'antennaLength' => $antennaLength,
        'groundLength' => $groundLength,
        'unit' => $resultUnit
    ];
}

// Zpracování formuláře
$frequency = 145; // Výchozí hodnota
$frequencyUnit = 'MHz'; // Výchozí jednotka
$antennaType = 'halfWave'; // Výchozí typ antény
$resultUnit = 'cm'; // Výchozí jednotka výsledku

$result = null;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["frequency"]) && isset($_POST["frequency_unit"]) && isset($_POST["antenna_type"]) && isset($_POST["result_unit"])) {
        $frequency = floatval($_POST["frequency"]);
        $frequencyUnit = $_POST["frequency_unit"];
        $antennaType = $_POST["antenna_type"];
        $resultUnit = $_POST["result_unit"];

        if ($frequency > 0) {
            $result = calculateAntennaLength($frequency, $frequencyUnit, $antennaType, $resultUnit);
        }
    }
}

// Pokud není výsledek, vypočítáme ho s výchozími hodnotami
if ($result === null) {
    $result = calculateAntennaLength($frequency, $frequencyUnit, $antennaType, $resultUnit);
}

// Funkce pro kontrolu, zda je typ antény vybrán
function isAntennaTypeSelected($type, $currentType) {
    return $type === $currentType ? 'selected' : '';
}

// Funkce pro kontrolu, zda je jednotka vybrána
function isUnitSelected($unit, $currentUnit) {
    return $unit === $currentUnit ? 'selected' : '';
}

// Nastavení tmavého režimu jako výchozího
$darkMode = true;
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Výpočet antény - AllHam</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
    <!-- Dark Mode CSS -->
    <link rel="stylesheet" href="css/dark-mode.css">
    <!-- Form Styles CSS -->
    <link rel="stylesheet" href="css/form-styles.css">
    <style>
        /* Tmavý režim jako výchozí */
        body {
            background-color: #121212;
            color: #e0e0e0;
        }

        .card {
            background-color: #1e1e1e;
            border-color: #333;
        }

        .card-body {
            color: #e0e0e0;
        }

        .form-control, .form-select {
            background-color: #2a2a2a;
            border-color: #444;
            color: #e0e0e0;
        }

        .form-control:focus, .form-select:focus {
            background-color: #333;
            color: #fff;
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }

        /* Výsledky */
        .result-item {
            margin-bottom: 1.5rem;
            padding: 1rem;
            background-color: #2a2a2a;
            border-radius: 0.5rem;
            border-left: 4px solid #0d6efd;
        }

        .result-item h4 {
            color: #0d6efd;
            margin-bottom: 0.5rem;
        }

        .result-item p {
            font-size: 1.2rem;
            margin-bottom: 0.25rem;
        }

        /* Accordion */
        .accordion-button {
            background-color: #2a2a2a;
            color: #e0e0e0;
        }

        .accordion-button:not(.collapsed) {
            background-color: #0d6efd;
            color: white;
        }

        .accordion-button:focus {
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }

        .accordion-body {
            background-color: #1e1e1e;
            color: #e0e0e0;
        }
    </style>
</head>
<body class="dark-mode">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">AllHam</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home"></i> Domů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="frequency.php"><i class="fas fa-broadcast-tower"></i> Frekvenční vizualizér</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="prefix.php"><i class="fas fa-globe"></i> Vyhledávání prefixů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="wavelength.php"><i class="fas fa-wave-square"></i> Délka vlny</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="callsign.php"><i class="fas fa-microphone"></i> Hláskovač</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="antenna.php"><i class="fas fa-satellite-dish"></i> Výpočet antény</a>
                    </li>
                </ul>

            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1 class="text-center mb-4 text-light">Výpočet délky antény</h1>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title">Parametry antény</h3>
                    </div>
                    <div class="card-body">
                        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                            <div class="mb-3">
                                <label for="frequency" class="form-label">Frekvence</label>
                                <div class="input-group">
                                    <input type="number" class="form-control" id="frequency" name="frequency" placeholder="Např. 145" value="<?php echo $frequency; ?>" step="any" required>
                                    <select class="form-select" id="frequency_unit" name="frequency_unit">
                                        <option value="Hz" <?php echo isUnitSelected('Hz', $frequencyUnit); ?>>Hz</option>
                                        <option value="kHz" <?php echo isUnitSelected('kHz', $frequencyUnit); ?>>kHz</option>
                                        <option value="MHz" <?php echo isUnitSelected('MHz', $frequencyUnit); ?>>MHz</option>
                                        <option value="GHz" <?php echo isUnitSelected('GHz', $frequencyUnit); ?>>GHz</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="antenna_type" class="form-label">Typ antény</label>
                                <select class="form-select" id="antenna_type" name="antenna_type" required>
                                    <option value="fullWave" <?php echo isAntennaTypeSelected('fullWave', $antennaType); ?>>Celovlnná anténa</option>
                                    <option value="halfWave" <?php echo isAntennaTypeSelected('halfWave', $antennaType); ?>>Půlvlnná anténa</option>
                                    <option value="quarterWave" <?php echo isAntennaTypeSelected('quarterWave', $antennaType); ?>>Čtvrtvlnná anténa</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="result_unit" class="form-label">Jednotky výsledku</label>
                                <select class="form-select" id="result_unit" name="result_unit">
                                    <option value="m" <?php echo isUnitSelected('m', $resultUnit); ?>>m</option>
                                    <option value="cm" <?php echo isUnitSelected('cm', $resultUnit); ?>>cm</option>
                                    <option value="mm" <?php echo isUnitSelected('mm', $resultUnit); ?>>mm</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Vypočítat</button>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h3 class="card-title">Výsledky výpočtu</h3>
                    </div>
                    <div class="card-body">
                        <div class="result-item">
                            <h4>Délka antény</h4>
                            <p><?php echo number_format($result['antennaLength'], 2) . ' ' . $result['unit']; ?></p>
                        </div>

                        <div class="result-item">
                            <h4>Délka radiálů (λ * 0,28)</h4>
                            <p><?php echo number_format($result['groundLength'], 2) . ' ' . $result['unit']; ?></p>
                        </div>

                        <div class="alert alert-info mt-3">
                            <i class="fas fa-info-circle"></i> Výsledky jsou přibližné a mohou se lišit v závislosti na konkrétních podmínkách a materiálech.
                        </div>
                    </div>
                </div>


            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h3 class="card-title">Informace o typech antén</h3>
                    </div>
                    <div class="card-body">
                        <div class="accordion" id="antennaInfo">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        Celovlnná anténa
                                    </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#antennaInfo">
                                    <div class="accordion-body">
                                        <p>Celovlnná anténa má délku rovnou jedné vlnové délce. Tyto antény mají vyšší zisk než půlvlnné antény, ale vyžadují více prostoru.</p>
                                        <p>Vzorec pro výpočet: <strong>λ = c / f</strong>, kde c je rychlost světla a f je frekvence.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingTwo">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        Půlvlnná anténa
                                    </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#antennaInfo">
                                    <div class="accordion-body">
                                        <p>Půlvlnná anténa má délku rovnou polovině vlnové délky. Jedná se o nejběžnější typ antény pro radioamatéry.</p>
                                        <p>Vzorec pro výpočet: <strong>λ/2 = c / (2 * f)</strong>, kde c je rychlost světla a f je frekvence.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingThree">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                        Čtvrtvlnná anténa
                                    </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#antennaInfo">
                                    <div class="accordion-body">
                                        <p>Čtvrtvlnná anténa má délku rovnou čtvrtině vlnové délky. Tyto antény jsou kompaktní a často se používají s protiváhou nebo zemní rovinou.</p>
                                        <p>Vzorec pro výpočet: <strong>λ/4 = c / (4 * f)</strong>, kde c je rychlost světla a f je frekvence.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-white text-center text-lg-start mt-4">
        <div class="container p-4">
            <div class="row">
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>O projektu AllHam</h5>
                    <p>
                        AllHam je komplexní nástroj pro radioamatéry, který poskytuje různé výpočty a informace užitečné pro radioamatérskou činnost.
                    </p>
                </div>
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>Kontakt</h5>
                    <p>
                        <a href="https://www.OK2HSS.cz" class="text-info">www.ok2hss.cz</a>
                    </p>
                </div>
            </div>
        </div>
        <div class="text-center p-3" style="background-color: rgba(0, 0, 0, 0.2);">
            © 2023 AllHam
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Dark Mode JS -->
    <script src="js/dark-mode.js"></script>
</body>
</html>
