<?php
// Funkce pro převod znaku na fonetickou abecedu
function getPhoneticCode($char) {
    $char = strtoupper($char);
    $phoneticCodes = [
        'A' => 'Alpha',
        'B' => 'Bravo',
        'C' => 'Charlie',
        'D' => 'Delta',
        'E' => 'Echo',
        'F' => 'Foxtrot',
        'G' => 'Golf',
        'H' => 'Hotel',
        'I' => 'India',
        'J' => 'Juliet',
        'K' => 'Kilo',
        'L' => 'Lima',
        'M' => 'Mike',
        'N' => 'November',
        'O' => 'Oscar',
        'P' => 'Papa',
        'Q' => 'Quebec',
        'R' => 'Romeo',
        'S' => 'Sierra',
        'T' => 'Tango',
        'U' => 'Uniform',
        'V' => 'Victor',
        'W' => 'Whiskey',
        'X' => 'X-ray',
        'Y' => 'Yankee',
        'Z' => 'Zulu',
        '0' => 'Zero',
        '1' => 'One',
        '2' => 'Two',
        '3' => 'Three',
        '4' => 'Four',
        '5' => 'Five',
        '6' => 'Six',
        '7' => 'Seven',
        '8' => 'Eight',
        '9' => 'Nine',
        '/' => 'Slash',
        '-' => 'Dash',
        '.' => 'Dot'
    ];

    return isset($phoneticCodes[$char]) ? $phoneticCodes[$char] : $char;
}

// Funkce pro převod volací značky na fonetickou abecedu
function convertCallsignToPhonetic($callsign) {
    $result = [];
    $callsign = trim($callsign);

    for ($i = 0; $i < strlen($callsign); $i++) {
        $char = $callsign[$i];
        $phonetic = getPhoneticCode($char);
        $result[] = [
            'char' => $char,
            'phonetic' => $phonetic
        ];
    }

    return $result;
}

// Zpracování formuláře
$callsign = '';
$phoneticResult = [];

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["callsign"])) {
    $callsign = trim($_POST["callsign"]);
    if (!empty($callsign)) {
        $phoneticResult = convertCallsignToPhonetic($callsign);
    }
}

// Nastavení tmavého režimu jako výchozího
$darkMode = true;
?>

<!DOCTYPE html>
<html lang="cs">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hláskovač - AllHam</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
    <!-- Dark Mode CSS -->
    <link rel="stylesheet" href="css/dark-mode.css">
    <!-- Form Styles CSS -->
    <link rel="stylesheet" href="css/form-styles.css">
    <style>
        /* Tmavý režim jako výchozí */
        body {
            background-color: #121212;
            color: #e0e0e0;
        }

        .card {
            background-color: #1e1e1e;
            border-color: #333;
        }

        .card-body {
            color: #e0e0e0;
        }

        .form-control, .form-select {
            background-color: #2a2a2a;
            border-color: #444;
            color: #e0e0e0;
        }

        .form-control:focus, .form-select:focus {
            background-color: #333;
            color: #fff;
            border-color: #0d6efd;
            box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
        }

        /* Tabulka */
        .table-dark {
            background-color: #2a2a2a;
            color: #e0e0e0;
        }

        .table-dark th {
            background-color: #0277bd;
            color: white;
            border-color: #0288d1;
        }

        .table-dark td {
            border-color: #444;
        }

        /* Výsledky */
        .phonetic-result {
            background-color: #2a2a2a;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-bottom: 1rem;
            border-left: 4px solid #0d6efd;
        }

        .phonetic-char {
            display: inline-block;
            font-size: 1.5rem;
            font-weight: bold;
            margin-right: 0.5rem;
            padding: 0.5rem 1rem;
            background-color: #0d6efd;
            color: white;
            border-radius: 0.25rem;
            min-width: 3rem;
            text-align: center;
        }

        .phonetic-word {
            display: inline-block;
            font-size: 1.5rem;
            margin-right: 1.5rem;
            color: #e0e0e0;
        }

        .phonetic-item {
            margin-bottom: 1rem;
        }
    </style>
</head>
<body class="dark-mode">
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">AllHam</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php"><i class="fas fa-home"></i> Domů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="frequency.php"><i class="fas fa-broadcast-tower"></i> Frekvenční vizualizér</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="prefix.php"><i class="fas fa-globe"></i> Vyhledávání prefixů</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="wavelength.php"><i class="fas fa-wave-square"></i> Délka vlny</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="callsign.php"><i class="fas fa-microphone"></i> Hláskovač</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="antenna.php"><i class="fas fa-satellite-dish"></i> Výpočet antény</a>
                    </li>
                </ul>

            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h1 class="text-center mb-4 text-light">Hláskovač volacích značek</h1>

        <div class="row">
            <div class="col-md-6 mx-auto">
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h3 class="card-title">Zadejte volací značku</h3>
                    </div>
                    <div class="card-body">
                        <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
                            <div class="mb-3">
                                <label for="callsign" class="form-label">Volací značka</label>
                                <input type="text" class="form-control" id="callsign" name="callsign" placeholder="Např. OK2HSS" value="<?php echo htmlspecialchars($callsign); ?>" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Hláskovat</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <?php if (!empty($phoneticResult)): ?>
            <div class="row mt-4">
                <div class="col-md-8 mx-auto">
                    <div class="card">
                        <div class="card-header bg-success text-white">
                            <h3 class="card-title">Fonetický přepis značky "<?php echo htmlspecialchars($callsign); ?>"</h3>
                        </div>
                        <div class="card-body">
                            <div class="phonetic-result">
                                <?php foreach ($phoneticResult as $item): ?>
                                    <div class="phonetic-item">
                                        <span class="phonetic-char"><?php echo htmlspecialchars($item['char']); ?></span>
                                        <span class="phonetic-word"><?php echo htmlspecialchars($item['phonetic']); ?></span>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-info text-white">
                        <h3 class="card-title">Mezinárodní fonetická abeceda</h3>
                    </div>
                    <div class="card-body">
                        <p>Mezinárodní fonetická abeceda (také známá jako NATO fonetická abeceda) se používá pro jasnou a jednoznačnou komunikaci, zejména v radioamatérském provozu, letectví a dalších oblastech, kde je důležitá přesnost.</p>

                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-dark">
                                    <thead>
                                        <tr>
                                            <th>Písmeno</th>
                                            <th>Kódové slovo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr><td>A</td><td>Alpha</td></tr>
                                        <tr><td>B</td><td>Bravo</td></tr>
                                        <tr><td>C</td><td>Charlie</td></tr>
                                        <tr><td>D</td><td>Delta</td></tr>
                                        <tr><td>E</td><td>Echo</td></tr>
                                        <tr><td>F</td><td>Foxtrot</td></tr>
                                        <tr><td>G</td><td>Golf</td></tr>
                                        <tr><td>H</td><td>Hotel</td></tr>
                                        <tr><td>I</td><td>India</td></tr>
                                        <tr><td>J</td><td>Juliet</td></tr>
                                        <tr><td>K</td><td>Kilo</td></tr>
                                        <tr><td>L</td><td>Lima</td></tr>
                                        <tr><td>M</td><td>Mike</td></tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-dark">
                                    <thead>
                                        <tr>
                                            <th>Písmeno</th>
                                            <th>Kódové slovo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr><td>N</td><td>November</td></tr>
                                        <tr><td>O</td><td>Oscar</td></tr>
                                        <tr><td>P</td><td>Papa</td></tr>
                                        <tr><td>Q</td><td>Quebec</td></tr>
                                        <tr><td>R</td><td>Romeo</td></tr>
                                        <tr><td>S</td><td>Sierra</td></tr>
                                        <tr><td>T</td><td>Tango</td></tr>
                                        <tr><td>U</td><td>Uniform</td></tr>
                                        <tr><td>V</td><td>Victor</td></tr>
                                        <tr><td>W</td><td>Whiskey</td></tr>
                                        <tr><td>X</td><td>X-ray</td></tr>
                                        <tr><td>Y</td><td>Yankee</td></tr>
                                        <tr><td>Z</td><td>Zulu</td></tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <table class="table table-dark">
                                    <thead>
                                        <tr>
                                            <th>Číslo</th>
                                            <th>Kódové slovo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr><td>0</td><td>Zero</td></tr>
                                        <tr><td>1</td><td>One</td></tr>
                                        <tr><td>2</td><td>Two</td></tr>
                                        <tr><td>3</td><td>Three</td></tr>
                                        <tr><td>4</td><td>Four</td></tr>
                                        <tr><td>5</td><td>Five</td></tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-dark">
                                    <thead>
                                        <tr>
                                            <th>Číslo</th>
                                            <th>Kódové slovo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr><td>6</td><td>Six</td></tr>
                                        <tr><td>7</td><td>Seven</td></tr>
                                        <tr><td>8</td><td>Eight</td></tr>
                                        <tr><td>9</td><td>Nine</td></tr>
                                        <tr><td>/</td><td>Slash</td></tr>
                                        <tr><td>-</td><td>Dash</td></tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-white text-center text-lg-start mt-4">
        <div class="container p-4">
            <div class="row">
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>O projektu AllHam</h5>
                    <p>
                        AllHam je komplexní nástroj pro radioamatéry, který poskytuje různé výpočty a informace užitečné pro radioamatérskou činnost.
                    </p>
                </div>
                <div class="col-lg-6 col-md-12 mb-4 mb-md-0">
                    <h5>Kontakt</h5>
                    <p>
                        <a href="https://www.OK2HSS.cz" class="text-info">www.ok2hss.cz</a>
                    </p>
                </div>
            </div>
        </div>
        <div class="text-center p-3" style="background-color: rgba(0, 0, 0, 0.2);">
            © 2023 AllHam
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Dark Mode JS -->
    <script src="js/dark-mode.js"></script>
</body>
</html>
